/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class NearestSchoolingThievesFishSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH);
    }

    protected void doTick(ServerLevel level, LivingEntity entity) {
        Brain brain = entity.getBrain();
        Predicate<AbstractFlockFish> predicate = livingEntity -> (livingEntity.canBeFollowed() || !livingEntity.isFollower()) && livingEntity.isAlive();
        List list = level.getEntitiesOfClass(AbstractFlockFish.class, entity.getBoundingBox().inflate(16.0), predicate);
        list.sort(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).distanceToSqr(arg_0)));
        brain.setMemory(FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH, (Object)list);
    }
}

